// MSM6295c module header

#define MAX_MSM6295c (2)

INT32 MSM6295cInit(INT32 nChip, INT32 nSamplerate, bool bAddSignal);
void MSM6295cSetSamplerate(INT32 nChip, INT32 nSamplerate);
void MSM6295cSetRoute(INT32 nChip, double nVolume, INT32 nRouteDir);
void MSM6295cReset(INT32 nChip);
void MSM6295cExit(INT32 nChip);

INT32 MSM6295cRender(INT32 nChip, INT16* pSoundBuf, INT32 nSegmenLength);
void MSM6295cCommand(INT32 nChip, UINT8 nCommand);
INT32 MSM6295cScan(INT32 nChip, INT32 nAction);

// for backwards compatibility. Remove when done configuring all banks
extern UINT8* MSM6295cROM;

// Call this in the driver to set the bank
void MSM6295cSetBank(INT32 nChip, UINT8 *pRomData, INT32 nStart, INT32 nEnd);

inline static UINT32 MSM6295cReadStatus(const INT32 nChip)
{
#if defined FBA_DEBUG
	extern INT32 nLastMSM6295cChip;
	if (!DebugSnd_MSM6295cInitted) bprintf(PRINT_ERROR, _T("MSM6295cReadStatus called without init\n"));
	if (nChip > nLastMSM6295cChip) bprintf(PRINT_ERROR, _T("MSM6295cReadStatus called with invalid chip %x\n"), nChip);
#endif

	extern UINT32 nMSM6295cStatus[MAX_MSM6295c];

	return nMSM6295cStatus[nChip];
}

